param([string]$url,
[string]$token,
[string]$job,
[string]$servers,
[string]$notify,
[string]$hold)

try{
        [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::SystemDefault
        [System.Net.ServicePointManager]::ServerCertificateValidationCallback = { $true }
        Invoke-WebRequest -Uri $url -Method "Post" -Body @{job=$job;server=$servers;notification=$notify;hold=$hold} -ContentType 'application/x-www-form-urlencoded'  -Headers @{'accessToken'=$token}
}
catch {
        $e = $_.Exception

        if(!$e){
            Write-Host "No Exception response available."
        }
        else{
            Write-Host "Exception details: "

            Write-Host ("`tMessage: " + $e.Message)
            Write-Host ("`tStatus code: " + $e.Response.StatusCode)
            Write-Host ("`tStatus description: " + $e.Response.StatusDescription)
            Write-Host "`tResponse: " -NoNewline

            $memStream = $e.Response.GetResponseStream()
            $readStream = New-Object System.IO.StreamReader($memStream)
            while ($readStream.Peek() -ne -1) {
                Write-Host $readStream.ReadLine()
            }
            $readStream.Dispose();
        }
}
