(function () {

    window.setTextBoxFocus = function (id) {
        var textBox = document.getElementById(id);
        if (textBox) {
            textBox.focus();
            textBox.select();
        }
    }

    window.setImage = async (imageElementId, imageStream) => {
        const arrayBuffer = await imageStream.arrayBuffer();
        const blob = new Blob([arrayBuffer]);
        const url = URL.createObjectURL(blob);
        const image = document.getElementById(imageElementId);
        if (!image)
            return;

        image.onload = () => {
            URL.revokeObjectURL(url);
        }
        image.src = url;
    }

    // initiates a file download in the browser for files generated in the C# code
    window.saveFile = function (bytesBase64, mimeType, fileName) {
        var fileUrl = "data:" + mimeType + ";base64," + bytesBase64;
        fetch(fileUrl)
            .then(response => response.blob())
            .then(blob => {
                var link = window.document.createElement("a");
                link.href = window.URL.createObjectURL(blob, { type: mimeType });
                link.download = fileName;
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            });
    }

    // provides file content for files selected in JS to C# without saving on the server
    window.getUploadedFile = (inputID) => {
        var inputEl = document.getElementById(inputID);
        if (inputEl.files.length == 0) {
            return "";
        }
        else if (inputEl.files[0].size > (4 * 1024 * 1024)) { // 4MB
            inputEl.value = "";
            alert("File size too large. Max allowed size is 4MB.");
            return "";
        }
        else if (inputEl.accept.length && inputEl.accept.indexOf(inputEl.files[0].name.split('.').pop()) < 0) {
            inputEl.value = "";
            alert("Allowed file types: " + inputEl.accept);
            return "";
        }
        const fileReader = new FileReader();
        return new Promise((resolve) => {
            fileReader.onloadend = function (e) {
                var data = {
                    fileName: inputEl.files[0].name,
                    fileData: e.target.result.split('base64,')[1]
                };
                resolve(data);
            };
            fileReader.readAsDataURL(inputEl.files[0]);
        });
    };

    window.setBurstSetInstance = function (dotNetObjectInstance) {
        try {
            window.burstSetInstance = dotNetObjectInstance;

        } catch (e) {
            console.error(e);
        }
    }

    window.uploadBurstSetFile = function (filename) {
        try {
            window.burstSetInstance.invokeMethodAsync("UploadBurstSetFile", filename);

        } catch (e) {
            console.error(e);
        }
    }

    window.getLastVisibleNavTreeElement = function () {
        return $("span[data-automation-path]")
            .filter(function (idx, ele) { return isElementInViewport(ele) })
            .last()
            .attr("data-automation-path");
    }

    window.scrollToItem = function (selector) {
        console.log("scrollToItem: " + selector)
        setTimeout(function () {
            var item = document.querySelector(selector);
            if (item) {
                item.scrollIntoView();
            }
        }, 300);
    }

    window.isElementInViewport = function (el) {

        // Special bonus for those using jQuery
        if (typeof jQuery === "function" && el instanceof jQuery) {
            el = el[0];
        }

        var rect = el.getBoundingClientRect();

        return (
            rect.top >= 0 &&
            rect.left >= 0 &&
            rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && /* or $(window).height() */
            rect.right <= (window.innerWidth || document.documentElement.clientWidth) /* or $(window).width() */
        );
    }

    window.removeOverlayClick = function () {
        try {
            setTimeout(function () {
                delete document.getElementsByClassName('mud-overlay')[0]._blazorEvents_1.handlers['click'];

            }, 500);
        } catch (e) {
        }
    };

    window.triggerFileDownload = (fileName, url) => {
        const anchorElement = document.createElement('a');
        anchorElement.href = url;
        anchorElement.download = fileName ?? '';
        anchorElement.click();
        anchorElement.remove();
    }

    window.getUrlData = (url) => {
        return fetch(url, {
            mode: 'cors',
            headers: {
                'Access-Control-Allow-Origin': '*'
            }
        })
            .then(response => response.json());
    }

    window.postUrlData = (url, data) => {
        return fetch(url, {
            method: 'POST',
            headers: {
                'Accept': 'application/json, text/plain, */*',
                'Content-Type': 'text/plain; charset=utf-8'
            },
            body: data
        })
            .then(response => response.text());
    }

    var tinyMCEEditorSetup = function (editor) {

        editor.options.register("distributionViewKey", { processor: "string" });
        editor.options.register("instanceId", { processor: "string" });

        editor.on('click', function (e) {

            try {
                var editor = this;
                var variable = $(e.target);
                if (!variable.hasClass("variable"))
                    return;

                var mouseLeft = e.pageX;
                var targetLeft = variable.offset().left;
                var targetWidth = variable.width();

                var pos = targetWidth - (mouseLeft - targetLeft);

                if (pos < 18) {
                    variable.remove();
                    if (editor.getContent().length === 0) {
                        // Edge condition. Empty editor doesn't fire save if a variable pill was the only content
                        editor.setContent("x");
                        editor.save();
                        editor.setContent("");
                    }
                    editor.save();
                } else {
                    window.rwActiveVariableEditInstance = variable;
                    window.rwActiveEditorInstance = editor;

                    var map = {};

                    $.each(variable.get(0).dataset, function (name, value) {
                        if (name.startsWith("rw_"))
                            map[name.substring(3)] = value;
                    });

                    var distributionViewKey = editor.options.get("distributionViewKey")

                    if (!distributionViewKey)
                        return;

                    window.distributionEditorInstances[distributionViewKey].invokeMethodAsync("InvokeEditVariable", JSON.stringify(map));
                }
            } catch (e) {
                console.error(e);
            }
        });

        editor.on('cut', function (e) {
            setTimeout(function () {
                editor.fire("change");
            },
                500);
        });

    }

    tinymce.PluginManager.add('rwsavedtemplates', (editor, url) => {
        const openDialog = () => editor.windowManager.open({
            title: 'ControlWORQ Saved Templates',
            body: {
                type: 'panel',
                items: [
                    {
                        type: 'input',
                        name: 'title',
                        label: 'Title'
                    }
                ]
            },
            buttons: [
                {
                    type: 'cancel',
                    text: 'Close'
                },
                {
                    type: 'submit',
                    text: 'Save',
                    buttonType: 'primary'
                }
            ],
            onSubmit: (api) => {
                const data = api.getData();
                /* Insert content when the window form is submitted */
                editor.insertContent('Title: ' + data.title);
                api.close();
            }
        });
        /* Add a button that opens a window */
        editor.ui.registry.addMenuItem('rwload', {
            text: 'Load Template',
            onAction: () => {
                var instanceId = editor.options.get("instanceId")

                if (!instanceId)
                    return;

                if (!window.distributionEditorInstances[instanceId])
                    return;

                window.distributionEditorInstances[instanceId].invokeMethodAsync("LoadMessageTemplate");
            }
        });
        editor.ui.registry.addMenuItem('rwsave', {
            text: 'Save Template',
            onAction: () => {
                var instanceId = editor.options.get("instanceId")

                if (!instanceId)
                    return;

                if (!window.distributionEditorInstances[instanceId])
                    return;

                window.distributionEditorInstances[instanceId].invokeMethodAsync("SaveMessageTemplate");
            }
        });
        /* Return the metadata for the help plugin */
        return {
            getMetadata: () => ({
                name: 'ControlWORQ Saved Templates',
                url: 'https://reportworq.com'
            })
        };
    });


    window.tinyMCEEditorConfig = {
        license_key: 'gpl',
        promotion: false,
        height: 500,
        content_css: [
            "css/tinymce_additions.css",
            "css/fontawesome/css/all.css"
        ],
        plugins: 'rwsavedtemplates preview searchreplace autolink code visualblocks fullscreen image link codesample table anchor advlist lists emoticons',
        menu: {
            rw_load: { title: 'Templates', items: 'rwload rwsave' }
        },
        menubar: 'rw_load edit view insert format table',
        toolbar: 'bold italic underline forecolor | blocks fontfamily fontsize | alignleft aligncenter alignright alignjustify | bullist outdent indent  | fullscreen  preview',
        setup: tinyMCEEditorSetup,
        valid_children: '+body[style]',
        entity_encoding: 'raw',
    }

    window.tinyMCEEditorSlimConfig = {
        license_key: 'gpl',
        promotion: false,
        content_css: [
            "css/tinymce_additions.css",
            "css/fontawesome/css/all.css"
        ],
        setup: tinyMCEEditorSetup,
        plugins: [],
        toolbar: false,
        menubar: false,
        inline: true,
        entity_encoding: 'raw',
    }

    window.tinyMCEEditorConfigNoEdit = {
        license_key: 'gpl',
        promotion: false,
        readonly: 1,
        content_css: [
            "css/tinymce_additions.css",
            "css/fontawesome/css/all.css"
        ],
        plugins: '',
        menubar: '',
        toolbar: '',
        valid_children: '+body[style]',
        entity_encoding: 'raw',
    }

    window.setDistributionViewDotNetInstance = function (dotNetObjectInstance, distributionViewKey) {
        try {
            if (!window.distributionEditorInstances)
                window.distributionEditorInstances = {};

            window.distributionEditorInstances[distributionViewKey] = dotNetObjectInstance;

        } catch (e) {
            console.error(e);
        }
    }

    window.removeDistributionViewDotNetInstance = function (distributionViewKey) {
        try {
            if (!window.distributionEditorInstances)
                window.distributionEditorInstances = {};

            delete window.distributionEditorInstances[distributionViewKey];

        } catch (e) {
            console.error(e);
        }
    }

    window.onSidebarSave = function (newData) {
        try {
            var map = JSON.parse(newData);

            $.each(map,
                function (name, value) {
                    window.rwActiveVariableEditInstance.get(0).dataset["rw_" + name] = value;
                });
            window.rwActiveVariableEditInstance.text(map["description"]);
            window.rwActiveEditorInstance.save();

        } catch (e) {
            console.error(e);
        }

    }


    window.setJobTabsViewDotNetInstance = function (dotNetObjectInstance) {
        try {
            window.JobTabsViewDotNetInstance = dotNetObjectInstance;

        } catch (e) {
            console.error(e);
        }
    }

    window.setCronDotNetInstance = function (id, dotNetObjectInstance) {
        try {
            if (!window.CronDotNetInstance)
                window.CronDotNetInstance = {};

            window.CronDotNetInstance[id] = dotNetObjectInstance;

        } catch (e) {
            console.error(e);
        }
    }

    window.renderCronComponent = function (id, initialCron) {
        window.cronInstance = $("#" + id).jqCron({
            enabled_minute: false,
            multiple_dom: true,
            multiple_month: true,
            multiple_mins: true,
            multiple_dow: true,
            multiple_time_hours: true,
            multiple_time_minutes: true,
            default_period: 'week',
            default_value: initialCron,
            no_reset_button: true,
            numeric_zero_pad: true,
            bind_to: $("#" + id),
            bind_method: {
                set: function (element, value) {
                    window.CronDotNetInstance[id].invokeMethodAsync("InvokeSetCron", value);
                }
            }
        }).jqCronGetInstance();
    }

    window.blazor_setdirtyState = function (value) {
        sessionHasUnsavedChanges = value;
    }

    window.setAppBodyDotNetInstance = function (dotNetHelper) {
        window.appBodyDotNetInstance = dotNetHelper;
    }

    window.copyToClipboard = function (text) {
        if (navigator.clipboard) {
            navigator.clipboard.writeText(text);
        }
        else {
            prompt("Your browser doesn't support copying to clipboard.\nPlease copy the text below manually:", text)
        }
    }

    var sessionHasUnsavedChanges = false;

    $(document).ready(function () {

        window.onbeforeunload = function () {
            if (sessionHasUnsavedChanges) {
                return "You have unsaved changes. Are you sure you want to leave this page?";
            } else {
                window.appBodyDotNetInstance.dispose();
            }
        }

        try {

            $('body').bind('dragstart', ".variable-template", function (e) {
                e.originalEvent.dataTransfer.setData('text/html', $(e.target).data("defaulthtml"));
            });

        } catch (e) {
            console.error(e);
        }


        $('body').on('keydown', ".k-treeview-item", function (e) {

            if (event.which == 113) { // F2
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeRename");
                return false;
            } else if (event.which == 67 && event.ctrlKey) { // Ctrl+C
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeCopy");
                return false;
            } else if (event.which == 88 && event.ctrlKey) { // Ctrl+X
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeCut");
                return false;
            } else if (event.which == 86 && event.ctrlKey) { // Ctrl+V
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokePaste");
                return false;
            } else if (event.which == 46) { // Del
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeDelete");
                return false;
            } else if (event.which == 13) { // Enter
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeOpen");
                return false;
            }

        });

        $('body').on('keydown', "", function (e) {

            if (event.ctrlKey && event.which == 83) { //CTRL+S
                if (window.JobTabsViewDotNetInstance)
                    window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeSave", event.shiftKey ? true : false);
                return false;
            }

        });


    });
})();
