﻿(function () {
    // initiates a file download in the browser for files generated in the C# code
    window.saveFile = function (bytesBase64, mimeType, fileName) {
        var fileUrl = "data:" + mimeType + ";base64," + bytesBase64;
        fetch(fileUrl)
            .then(response => response.blob())
            .then(blob => {
                var link = window.document.createElement("a");
                link.href = window.URL.createObjectURL(blob, { type: mimeType });
                link.download = fileName;
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            });
    }

    // provides file content for files selected in JS to C# without saving on the server
    window.getUploadedFile = (inputID) => {
        var inputEl = document.getElementById(inputID);
        if (inputEl.files.length == 0) {
            return "";
        }
        else if (inputEl.files[0].size > (4 * 1024 * 1024)) { // 4MB
            inputEl.value = "";
            alert("File size too large. Max allowed size is 4MB.");
            return "";
        }
        else if (inputEl.accept.length && inputEl.accept.indexOf(inputEl.files[0].name.split('.').pop()) < 0) {
            inputEl.value = "";
            alert("Allowed file types: " + inputEl.accept);
            return "";
        }
        const fileReader = new FileReader();
        return new Promise((resolve) => {
            fileReader.onloadend = function (e) {
                var data = {
                    fileName: inputEl.files[0].name,
                    fileData: e.target.result.split('base64,')[1]
                };
                resolve(data);
            };
            fileReader.readAsDataURL(inputEl.files[0]);
        });
    };


    window.removeOverlayClick = function () {
        try {
            setTimeout(function () {
                delete document.getElementsByClassName('mud-overlay')[0]._blazorEvents_1.handlers['click'];

            }, 500);
        } catch (e) {
        }
    };

    window.triggerFileDownload = (fileName, url) => {
        const anchorElement = document.createElement('a');
        anchorElement.href = url;
        anchorElement.download = fileName ?? '';
        anchorElement.click();
        anchorElement.remove();
    }

    window.getUrlData = (url) => {
        return fetch(url, {
            mode: 'cors',
            headers: {
                'Access-Control-Allow-Origin': '*'
            }
        })
            .then(response => response.json());
    }

    window.postUrlData = (url, data) => {
        return fetch(url, {
            method: 'POST',
            headers: {
                'Accept': 'application/json, text/plain, */*',
                'Content-Type': 'text/plain; charset=utf-8'
            },
            body: data
        })
            .then(response => response.text());
    }


    var tinyMCEEditorSetup = function (editor) {
        editor.on('click', function (e) {

            try {
                var editor = this;
                var variable = $(e.target);
                if (!variable.hasClass("variable"))
                    return;

                var mouseLeft = e.pageX;
                var targetLeft = variable.offset().left;
                var targetWidth = variable.width();

                var pos = targetWidth - (mouseLeft - targetLeft);

                if (pos < 18) {
                    variable.remove();
                    if (editor.getContent().length === 0) {
                        // Edge condition. Empty editor doesn't fire save if a variable pill was the only content
                        editor.setContent("x");
                        editor.save();
                        editor.setContent("");
                    }
                    editor.save();
                } else {
                    window.rwActiveVariableEditInstance = variable;
                    window.rwActiveEditorInstance = editor;

                    var map = {};

                    $.each(variable.get(0).dataset, function (name, value) {
                        if (name.startsWith("rw_"))
                            map[name.substring(3)] = value;
                    });

                    var distributionViewKey = map["distribution_view_key"];
                    if (!distributionViewKey)
                        return;

                    window.distributionEditorInstances[distributionViewKey].invokeMethodAsync("InvokeEditVariable", JSON.stringify(map));
                }
            } catch (e) {
                console.error(e);
            }
        });

        editor.on('cut', function (e) {
            setTimeout(function() {
                    editor.fire("change");
                },
                500);
        });
    }

    window.tinyMCEEditorConfig = {
        height: 500,
        content_css: [
            "css/tinymce_additions.css",
            "css/fontawesome/css/all.css"
        ],
        plugins: 'preview paste importcss searchreplace autolink code visualblocks visualchars fullscreen image link codesample table hr anchor insertdatetime advlist lists imagetools textpattern noneditable help emoticons',
        menubar: 'edit view insert format tools table help',
        toolbar: 'undo redo | bold italic underline strikethrough | fontselect fontsizeselect formatselect | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat  | emoticons | fullscreen  preview  | link anchor codesample',
        toolbar_sticky: true,
        setup: tinyMCEEditorSetup,
        valid_children: '+body[style]',
        entity_encoding: 'raw',
    }

    window.tinyMCEEditorSlimConfig = {
        content_css: [
            "css/tinymce_additions.css",
            "css/fontawesome/css/all.css"
        ],
        setup: tinyMCEEditorSetup,
        plugins: [],
        toolbar: false,
        menubar: false,
        inline: true,
        entity_encoding: 'raw',
    }

    window.setDistributionViewDotNetInstance = function (dotNetObjectInstance, distributionViewKey) {
        try {
            if (!window.distributionEditorInstances)
                window.distributionEditorInstances = {};

            window.distributionEditorInstances[distributionViewKey] = dotNetObjectInstance;

        } catch (e) {
            console.error(e);
        }
    }

    window.removeDistributionViewDotNetInstance = function (distributionViewKey) {
        try {
            if (!window.distributionEditorInstances)
                window.distributionEditorInstances = {};

            delete window.distributionEditorInstances[distributionViewKey];

        } catch (e) {
            console.error(e);
        }
    }

    window.onSidebarSave = function (newData) {
        try {
            var map = JSON.parse(newData);

            $.each(map,
                function (name, value) {
                    window.rwActiveVariableEditInstance.get(0).dataset["rw_" + name] = value;
                });
            window.rwActiveVariableEditInstance.text(map["description"]);
            window.rwActiveEditorInstance.save();

        } catch (e) {
            console.error(e);
        }

    }


    window.setJobTabsViewDotNetInstance = function (dotNetObjectInstance) {
        try {
            window.JobTabsViewDotNetInstance = dotNetObjectInstance;

        } catch (e) {
            console.error(e);
        }
    }

    window.setSchedulerViewDotNetInstance = function (dotNetObjectInstance) {
        try {
            window.SchedulerViewDotNetInstance = dotNetObjectInstance;

        } catch (e) {
            console.error(e);
        }
    }

    window.renderCronComponent = function (initialCron) {
        window.cronInstance = $("#cronEditor").jqCron({
            enabled_minute: false,
            multiple_dom: true,
            multiple_month: true,
            multiple_mins: true,
            multiple_dow: true,
            multiple_time_hours: true,
            multiple_time_minutes: true,
            default_period: 'week',
            default_value: initialCron,
            no_reset_button: true,
            numeric_zero_pad: true,
            bind_to: $('#cronEditor'),
            bind_method: {
                set: function (element, value) {
                    window.SchedulerViewDotNetInstance.invokeMethodAsync("InvokeSetCron", value);
                }
            }
        }).jqCronGetInstance();
    }


    $(document).ready(function () {

        try {

            $('body').bind('dragstart', ".variable-template", function (e) {
                e.originalEvent.dataTransfer.setData('text/html', $(e.target).data("defaulthtml"));
            });

        } catch (e) {
            console.error(e);
        }


        $('body').on('keydown', ".k-treeview-item", function (e) {

            if (event.which == 113) { // F2
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeRename");
                return false;
            } else if (event.which == 67 && event.ctrlKey) { // Ctrl+C
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeCopy");
                return false;
            } else if (event.which == 88 && event.ctrlKey) { // Ctrl+X
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeCut");
                return false;
            } else if (event.which == 86 && event.ctrlKey) { // Ctrl+V
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokePaste");
                return false;
            } else if (event.which == 46) { // Del
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeDelete");
                return false;
            } else if (event.which == 13) { // Enter
                window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeOpen");
                return false;
            }

        });

        $('body').on('keydown', "", function (e) {

            if (event.ctrlKey && event.which == 83) { //CTRL+S
                if (window.JobTabsViewDotNetInstance)
                    window.JobTabsViewDotNetInstance.invokeMethodAsync("InvokeSave", event.shiftKey ? true : false);
                return false;
            }

        });


    });


    //window.tinyMCEInsertVariable = function (id, html) {
    //    try {
    //        tinymce.get(id).execCommand("mceInsertContent", false, html);
    //    } catch (e) {
    //        console.error(e);
    //    }
    //}

})();


/*
  // PILL SUPPORT


function nativeBindDraggable(elems) {

        elems.each(function () {
            var $this = $(this);

            $this.unbind('dragstart');

            $this.on("dragstart", "", function (e) {
                var variable = $(e.target);

                window.inTransferMarkup = variable.prop('outerHTML');

                if (variable.hasClass("variable-instance"))
                    variable.addClass('dragged');
            });

        });
    }

    function nativeBindWriteRegion(elems) {

        elems.each(function () {
            var $this = $(this);

            $this.unbind('dragover');
            $this.unbind('drop');

            $this.on("dragover", "", function (e) {
                e.preventDefault();
                return false;
            });

            $this.on("drop", "", function (e) {
                e.preventDefault();
                receiveBlock($(e.target), e);
            });
        });

    }

    function receiveBlock(textbox, e) {

        if (!textbox.hasClass("native_receiver"))
            return false;

        var content = window.inTransferMarkup;

        window.inTransferMarkup = "";

        var range = null;
        if (document.caretRangeFromPoint) { // Chrome
            range = document.caretRangeFromPoint(e.clientX, e.clientY);
        } else if (e.rangeParent) { // Firefox
            range = document.createRange();
            range.setStart(e.rangeParent, e.rangeOffset);
        }

        var isDropOnTextbox = $(range.startContainer).parent().hasClass("native_receiver");
        if (!isDropOnTextbox)
            return false;

        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange(range);
        e.target.focus();

        var span = $(content);

        if (span.hasClass("variable-template")) {
            var html = span.data("defaulthtml");
            span = $(html);
        }

        span.removeClass("dragged");

        range.insertNode(span.get(0));
        sel.removeAllRanges();

        nativeBindDraggable(span);

        if (!e.ctrlKey) {
            var sourceTextbox = $('.dragged').closest(".native_receiver");
            $('.dragged').remove();
            if (sourceTextbox !== textbox)
                sourceTextbox.trigger('change');
        }

        var textBoxHtml = textbox.html();
        if (!textBoxHtml.startsWith("&nbsp;"))
            textbox.prepend("&nbsp;");

        if (!textBoxHtml.endsWith("&nbsp;"))
            textbox.append("&nbsp;");

        textbox.trigger('change');

        return false;
    }

    window.initializeTextBox = function (fieldName, value) {
        $(".native_receiver[data-fieldname='" + fieldName + "']").html(value);
    }

    window.initializeDraggable = function (dotNetObjectInstance) {
        window.dotNetObjectInstance = dotNetObjectInstance;
        nativeBindDraggable($('.native_drag'));
        nativeBindWriteRegion($('.native_receiver'));
    }


    window.onSidebarSave = function (html) {
        var textbox = window.rwActiveVariableEditInstance.closest(".native_receiver");
        var newElem = $(html);
        window.rwActiveVariableEditInstance.replaceWith(newElem);
        nativeBindDraggable(newElem);
        textbox.trigger('change');
    }

 $('body')
        .on('focus',
            '.native_receiver',
            function () {
                var $this = $(this);
                $this.data('before', $this.html());
            })
        .on('blur keyup paste input',
            '.native_receiver',
            function () {
                var $this = $(this);

                if ($this.data('before') !== $this.html()) {
                    $this.data('before', $this.html());
                    $this.trigger('change');
                }
            })
        .on('change',
            '.native_receiver',
            function () {
                var $this = $(this);
                window.dotNetObjectInstance.invokeMethodAsync("InvokeVariableTextBoxChange", $this.attr("data-fieldname"), $this.html());
            })
        .on('click',
            '.variable-instance',
            function (e) {
                var $this = $(this);


                var pos = $this.width() - e.offsetX;
                if (pos < 9) {
                    $this.remove();
                    $this.closest(".native_receiver").trigger('change');
                } else {

                    window.rwActiveVariableEditInstance = $this;
                    window.dotNetObjectInstance.invokeMethodAsync("InvokeEditVariable", $this.attr("data-code"));
                }
            });
 */
